package org.example.demo.waluty;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TabelaWalut {
    private final String typ;
    private final String numer;
    private final LocalDate data;
    private final List<Waluta> waluty = new ArrayList<>();
    
    public TabelaWalut(String typ, String numer, LocalDate data) {
        this.typ = typ;
        this.numer = numer;
        this.data = data;
    }

    public String getTyp() {
        return typ;
    }

    public String getNumer() {
        return numer;
    }

    public LocalDate getData() {
        return data;
    }
    
    public Collection<Waluta> getWaluty() {
        return Collections.unmodifiableList(waluty);
    }

    @Override
    public String toString() {
        return "Tabela nr " + numer + " z dnia " + data + ", " + waluty.size() + " walut";
    }

    public void dodajWalute(Waluta waluta) {
        this.waluty.add(waluta);
    }

    public Waluta wyszukaj(String kod) {
        for(Waluta waluta : waluty) {
            if(waluta.getKod().equals(kod)) {
                return waluta;
            }
        }
        return null;
    }
    
    public String[] getKodyWalut() {
         return this.waluty.stream()
                         .map(Waluta::getKod)
                         .sorted()
                         .toArray(String[]::new);
    }

}
