package org.example.demo;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class KalkulatorController {

    @GetMapping("/kalkulator")
    public String dzialaj(Long liczba1, Long liczba2, String operacja, Model model) {
        if(liczba1 != null && liczba2 != null && operacja != null) {
            long wynik = oblicz(liczba1, liczba2, operacja);
            model.addAttribute("wynik", wynik);
        }
        return "kalkulator.html";
    }
    
    private long oblicz(long liczba1, long liczba2, String operacja) {
        return switch (operacja) {
            case "+" -> liczba1 + liczba2;
            case "-" -> liczba1 - liczba2;
            case "*" -> liczba1 * liczba2;
            case "/" -> liczba1 / liczba2;
            default -> 0;
        };
    }
}
