package sklep.serwlety;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import sklep.model.Product;

// Wersja z ręcznym uzyskaniem dostępu do `persistence` - poprzez fabrykę, a nie wstrzykiwanie zależności.
// To jest napisane niemal tak, jak "zwykły program z mainem".
// To serwer zapewnia implementację JPA - my nie dodajemy jej do pom.xml (dodajemy tylko javaee-web-api)
// WildFly użyje Hibernate, a Glassfish użyje Eclipse Link.
// Wersja zadziała także przy konfiguracji połączenia "RESOURCE_LOCAL" z parametrami połączenia podanymi w persistence.xml
@WebServlet("/lista1")
public class Lista1 extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        
        EntityManagerFactory emf = null;
        EntityManager em = null;
        try {
            emf = Persistence.createEntityManagerFactory("sklep");
            em = emf.createEntityManager();
            
            TypedQuery<Product> query = em.createNamedQuery("Product.findAll", Product.class);
            List<Product> products = query.getResultList();
            out.println("Odczytano " + products.size() + " rekordów:");
            for (Product product : products) {
                out.println(product.getProductName() + " " + product.getPrice());
            }
        } catch(Exception e) {
            out.println("Wyjątek: " + e);
        } finally {
            if(em != null) em.close();
            if(emf != null) emf.close();
        }
    }

}
