package sklep.serwlety;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import sklep.model.Product;

// http://localhost:8080/PC29-HibernateNaSerwerze-1.0/Lista0
@WebServlet("/lista0")
public class Lista0 extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        
        // W tej wersji obiekty JPA (emf i em) otwieram w sposób ogólny, tak jakby to była zwykła aplikacja.
        // Nie zakładam, że jestem na serwerze.
        EntityManagerFactory emf = null;
        EntityManager em = null;
        try {
            emf = Persistence.createEntityManagerFactory("sklep");
            em = emf.createEntityManager();
            out.println("Mam połączenie. em = " + em);
            TypedQuery<Product> query = em.createNamedQuery("Product.findAll", Product.class);
            List<Product> products = query.getResultList();
            out.println("Odczytano " + products.size() + " produktów:");
            for (Product product : products) {
                out.println(" * " + product.getProductName() + " za " + product.getPrice());
            }
            
        } catch(Exception e) {
            out.println("Katastrofa " + e);
            e.printStackTrace(out);
        } finally {
            if(em != null) em.close();
            if(emf != null) emf.close();
        }
        
    }

}
