package sklep.programy;

import java.util.Arrays;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;

public class P10_ProduktyIZamowienia {

    // Z obiektu Product nie ma bezpośredniego dowiązania do OrderProduct i pośrednio Order.
    // Jeśli chcę uzyskać listę zamówień dla kadego produktu, mogę napisać zapytanie łączące kilka tabel
    // na podobnych zasadach, jak w zwykłym SQL.
    public static void main(String[] args) {
        try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("sklep_pu");
            EntityManager em = emf.createEntityManager()) {
            
            String queryString = """
                SELECT p.productName, p.price, o.id, o.orderDate, o.customer.customerEmail, op.actualPrice, op.quantity
                FROM Product p
                    JOIN OrderProduct op ON op.id.productId = p.id
                    JOIN Order o ON op.id.orderId = o.id
                ORDER BY p.id, o.id
                """;
            em.createQuery(queryString, Object[].class).getResultStream()
                .map(Arrays::toString)
                .forEachOrdered(System.out::println);
        }

    }

}
