package sklep.programy;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;
import sklep.model.Product;

import java.util.List;

// Często używane zapytania można zdefiniować za pomocą adnotacji @NamedQuery (lub @NamedQueries) w klasach encji,
// a następnie odnosić się do nich w metodzie createNamedQuery
public class P05_WszystkieProdukty_NamedQuery {

    public static void main(String[] args) {
        try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("sklep_pu");
            EntityManager em = emf.createEntityManager()
        ) {
            TypedQuery<Product> query = em.createNamedQuery("Product.findAll", Product.class);
            List<Product> products = query.getResultList();
            System.out.println("Odczytano " + products.size() + " rekordów:");
            for (Product product : products) {
                System.out.println(product.getProductName() + " za cenę " + product.getPrice());
            }
        }
    }
}
