package sklep.programy;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import sklep.model.Customer;
import sklep.model.Order;
import sklep.model.OrderProduct;

import java.util.Scanner;

public class P03_OdczytajZamowienie {

    public static void main(String[] args) {
        try(Scanner scanner = new Scanner(System.in);
            EntityManagerFactory emf = Persistence.createEntityManagerFactory("sklep_pu");
            EntityManager em = emf.createEntityManager()
        ) {
            while(true) {
                System.out.print("Podaj nr zamówienia: ");
                int id = scanner.nextInt();
                if(id == 0) break;
                Order order = em.find(Order.class, id);
                if(order == null) {
                    System.out.println("Nie ma zamówienia o numerze " + id);
                    continue;
                }
                System.out.println("Odczytany obiekt: " + order);
                System.out.println("Zamówienie z dnia " + order.getOrderDate());
                if(order.getDeliveryDate() != null) {
                    System.out.println("Data dostawy: " + order.getDeliveryDate());
                }
                // Mając wczytany jeden obiekt, możemy za pomocą gettera odczytać obiekt z innej tabeli, który jest powiązany z bieżącym
                Customer customer = order.getCustomer();
                System.out.println("Odczytany obiekt klienta: " + customer + " klasy " + customer.getClass());
                System.out.println(customer.getCustomerEmail() + " " + customer.getCustomerName());
                System.out.println("Produkty:");
                for (OrderProduct op : order.getOrderProducts()) {
                    System.out.println(" * " + op.getProduct().getProductName() + " za cenę " + op.getActualPrice());
                }
                System.out.println();
            }
        }
    }
}
