package sklep.programy;

import java.util.Scanner;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;

import sklep.model.Product;

public class P02_OdczytWPetli {

    public static void main(String[] args) {
        try(Scanner scanner = new Scanner(System.in);
            EntityManagerFactory emf = Persistence.createEntityManagerFactory("sklep_pu");
            EntityManager em = emf.createEntityManager()) {
            while(true) {
                System.out.print("\nPodaj id produktu (0 kończy program): ");
                int productId = scanner.nextInt();
                if (productId == 0) break;

                Product product = em.find(Product.class, productId);
                if (product == null) {
                    System.out.println("Nie ma takiego produktu");
                    continue;
                }
                System.out.println("Odczytany produkt: " + product);
                System.out.println(product.getProductName() + " za cenę " + product.getPrice());
                if (product.getDescription() != null) {
                    System.out.println(product.getDescription());
                }
            }
        }
    }

}
