package hr.programy;

import java.util.Scanner;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import hr.model.Employee;

public class OdczytajManagerow {

    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        EntityManagerFactory emf = null;
        EntityManager em = null;
        try {
            emf = Persistence.createEntityManagerFactory("hr_postgresql");
            em = emf.createEntityManager();
        
            while(true) {
                System.out.print("\nPodaj id pracownika: ");
                if(!sc.hasNextInt())
                    break;
                int id = sc.nextInt();
                Employee emp = em.find(Employee.class, id);
                
                if(emp == null) {
                    System.out.println("nie znaleziono takiego pracownika");
                    continue;
                }
                
                while(emp != null) {
                    System.out.println("    " + emp.getEmployeeId() + " " + emp.getFirstName() + " " + emp.getLastName()
                        + "(" + emp.getJob().getJobTitle() + ")" + " $" + emp.getSalary());
                    emp = emp.getManager();
                    System.out.println("Managerem jest:");
                }
            }
        } finally {
            if(em != null)
                em.close();
            if(emf != null)
                emf.close();
        }
    }
}
