package hr.programy;

import java.util.stream.Stream;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;
import hr.model.Employee;

public class Odczyt04_WszystkieRekordy_Stream {

    public static void main(String[] args) {
        EntityManagerFactory emf = null;
        EntityManager em = null;
        try {
            emf = Persistence.createEntityManagerFactory("hr_postgresql");
            em = emf.createEntityManager();

            TypedQuery<Employee> query = em.createNamedQuery("Employee.findAll", Employee.class);
            // Używając Stream zamiast List pobieramy dane "strumieniowo", czyli pojedynczo i przetwarzamy na bieżąco.
            try(Stream<Employee> stream = query.getResultStream()) {
                stream.forEach(emp ->  {
                    System.out.println(emp.getFirstName() + " " + emp.getLastName());
                });
            }
        } finally {
            if (em != null)
                em.close();
            if (emf != null)
                emf.close();
        }
    }
}
