package waluty;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class TabelaWalut {
    private final String no;
    private final LocalDate effectiveDate;
    private final List<Waluta> rates = new ArrayList<>();
    
    public TabelaWalut(String no, LocalDate effectiveDate) {
        this.no = no;
        this.effectiveDate = effectiveDate;
    }
    
    public TabelaWalut(String no, String effectiveDate) {
        this(no, LocalDate.parse(effectiveDate));
    }
    
    public void addRate(Waluta waluta) {
        rates.add(waluta);
    }

    public String getNo() {
        return no;
    }

    public LocalDate getEffectiveDate() {
        return effectiveDate;
    }

    public List<Waluta> getRates() {
        // dostęp tylko do odczytu
        return Collections.unmodifiableList(rates);
    }
    
    @Override
    public String toString() {
        return "Tabela nr " + no + " z dnia " + effectiveDate + ", " + rates.size() + " walut";
    }

    public Optional<Waluta> findByCode(String code) {
        for(Waluta waluta : rates) {
            if(waluta.getCode().equals(code) ) {
                return Optional.of(waluta);
            }
        }
        return Optional.empty();
    }

    public String[] codes() {
        return rates.stream()
                .map(Waluta::getCode)
                .toArray(String[]::new);
    }

}
