package waluty;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Optional;
import java.util.Scanner;

/* Napisz program, który pobiera aktualne kursy (dodatkowa opcja - możliwość podania daty i pobranie archowalnego)
 * 
 * Następnie: użytkownik podaje kod waluty oraz kwotę, a program przelicza kwotę w tej walucie na złote
 * (ew. przeliczanie w drugą stronę)
 */
public class ProstyPrzelicznik {

    public static void main(String[] args) {
        Pobieranie pobieranie = Pobieranie.utworz("JSON");
        Scanner scanner = new Scanner(System.in);
        scanner.useLocale(Locale.US);
        
        System.out.println("Podaj datę lub naciśnij enter, aby pobrać najnowsze kursy:");
        String data = scanner.nextLine();
        try {
            TabelaWalut tabela = data.isBlank() ? pobieranie.pobierzBiezaceKursy() : pobieranie.pobierzArchiwalneKursy(data);
            System.out.println("Pobrano tabelę: " + tabela);
            
            System.out.println("\nPodawaj kwoty do przeliczenia w postaci 1000 USD , a żeby zakończyć wpisz Q");
            while(true) {
                System.out.print("> ");
                if(scanner.hasNextBigDecimal()) {
                    BigDecimal kwota = scanner.nextBigDecimal();
                    String kod = scanner.next().toUpperCase();
                    Optional<Waluta> found = tabela.findByCode(kod);
                    if(found.isPresent()) {
                        Waluta waluta = found.get();
                        BigDecimal wynik = waluta.przeliczNaZlote(kwota);
                        System.out.println(wynik + " PLN");
                    } else {
                        System.out.println("Nieznana waluta");
                    }
                } else {
                    if(scanner.next().equalsIgnoreCase("Q"))
                        break;
                }
            }
        } catch (BladAplikacji e) {
            System.out.println("Nastąpił błąd: " + e);
            e.printStackTrace(System.out);
        }
        System.out.println("Do widzenia");
    }

}
