package pogoda;

import java.util.List;
import java.util.Optional;
import java.util.Scanner;

public class PobierzPogodeDlaMiast {

    public static void main(String[] args) {
        try(Scanner sc = new Scanner(System.in);
            PobieraczkaPogody pobieraczka = new PobieraczkaPogody()) {

            while(true) {
                System.out.print("Podaj nazwę miasta: ");
                String miasto = sc.nextLine();
                if(miasto.isEmpty()) break;
                List<Lokalizacja> lokalizacje = pobieraczka.szukajLokalizacji(miasto);
                System.out.println("Znalezione lokalizacje (" + lokalizacje.size() + ")");
                for(Lokalizacja l : lokalizacje) {
                    System.out.println(l);
                }
                if(lokalizacje.size() > 0) {
                    System.out.println("pobieram pogodę dla pierwszej z nich");
                    Lokalizacja l = lokalizacje.getFirst(); // albo get(0)
                    Optional<Pogoda> pogoda = pobieraczka.pobierzAktualnaPogode(l.latitude(), l.longitude());
                    if(pogoda.isPresent()) {
                        System.out.println(pogoda.get());
                    } else {
                        System.out.println("Nie ma wyniku");
                    }	
                }				
                System.out.println();
            }
            
        }
    }

}
