package pogoda;

import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpResponse.BodyHandlers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;

public class PobieraczkaPogody implements AutoCloseable {
    private static final String adresBazowyGeolokalizacji = "https://geocoding-api.open-meteo.com/v1/search";
    private static final String adresBazowyPogody = "https://api.open-meteo.com/v1/forecast";
    
    private final HttpClient httpClient = HttpClient.newHttpClient();
    
    @Override
    public void close() {
        httpClient.close();
    }

    public List<Lokalizacja> szukajLokalizacji(String nazwa) {
        try {
            String adres = adresBazowyGeolokalizacji + "?name=" + nazwa;
            System.out.println("wysyłam zapytanie pod adres: " + adres);
            HttpRequest request = HttpRequest.newBuilder(new URI(adres)).build();
            HttpResponse<InputStream> response = httpClient.send(request, BodyHandlers.ofInputStream());
            System.out.println(response.statusCode() + " " + response.headers().firstValue("Content-Type"));
            if(response.statusCode() == 200) {
                List<Lokalizacja> lista = new ArrayList<>();
                try(JsonReader reader = Json.createReader(response.body())) {
                    JsonObject dane = reader.readObject();
                    JsonArray results = dane.getJsonArray("results");
                    if(results != null) for(JsonValue wpis : results) {
                        JsonObject znalezione = wpis.asJsonObject();
                        Lokalizacja lokalizacja = new Lokalizacja(
                                znalezione.getString("name"),
                                znalezione.getString("country"),
                                znalezione.getJsonNumber("population").intValue(),
                                znalezione.getJsonNumber("latitude").doubleValue(),
                                znalezione.getJsonNumber("longitude").doubleValue());
                        lista.add(lokalizacja);
                    }                 
                }
                return lista;
            } else {
                return List.of();        	
            }
        } catch (Exception e) {
            System.err.println(e);
            return List.of();
        }
    }

    public Optional<Pogoda> pobierzAktualnaPogode(double latitude, double longitude) {
        try {
            String adres = adresBazowyPogody + "?latitude=" + latitude + "&longitude=" + longitude + "&current=" + String.join(",", Pogoda.POLA_POGODY);
            System.out.println("wysyłam zapytanie pod adres: " + adres);
            HttpRequest request = HttpRequest.newBuilder(new URI(adres)).build();
            HttpResponse<InputStream> response = httpClient.send(request, BodyHandlers.ofInputStream());
            System.out.println(response.statusCode() + " " + response.headers().firstValue("Content-Type"));
            if(response.statusCode() == 200) {
                try(JsonReader reader = Json.createReader(response.body())) {
                    JsonObject dane = reader.readObject();
                    System.out.println(dane);
                    JsonObject pogoda = dane.getJsonObject("current");
                    return Optional.of(new Pogoda(
                                dane.getJsonNumber("latitude").doubleValue(),
                                dane.getJsonNumber("longitude").doubleValue(),
                                pogoda.getJsonNumber("temperature_2m").doubleValue(),
                                pogoda.getJsonNumber("wind_speed_10m").doubleValue()));
                }
            } else {
                return Optional.empty();
            }
        } catch (Exception e) {
            System.err.println(e);
            return Optional.empty();
        }
    }

}
