package pogoda;

import java.awt.Dimension;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.SpringLayout;
import javax.swing.SwingWorker;
import javax.swing.JLabel;
import java.awt.Font;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.JSpinner;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.awt.event.ActionEvent;

public class OknoPogodowe {
    private static final Font LABEL_FONT = new Font("Dialog", Font.BOLD, 18);
    private static final Font TEXT_FONT = new Font("Dialog", Font.BOLD, 20);
    private static final Font RESULT_FONT = new Font("Dialog", Font.BOLD, 20);
    private static final Font BUTTON_FONT = new Font("Dialog", Font.BOLD, 20);
    
    private PobieraczkaPogody pobieraczka = new PobieraczkaPogody();
    private JFrame frame;
    private JTextField txtMiasto;
    private JSpinner spinner_Lon;
    private JSpinner spinner_Lat;
    private JLabel lblT;
    private JLabel lblW;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable() {
            public void run() {
                try {
                    OknoPogodowe window = new OknoPogodowe();
                    window.frame.setVisible(true);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public OknoPogodowe() {
        initialize();
    }

    private void initialize() {
        frame = new JFrame();
        frame.setTitle("Informacja o pogodzie");
        frame.setSize(600, 500);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        SpringLayout springLayout = new SpringLayout();
        frame.getContentPane().setLayout(springLayout);
        
        int odstepPionowyDuzy = 20;
        int odstepPionowyMaly = 10;
        int marginesPoziomy = 15;
        int wciecie = 30;
        Dimension spinnerSize = new Dimension(120, 40);
        Dimension buttonSize = new Dimension(300, 40);
        Dimension lblSize = new Dimension(200, 40);
        Dimension resultSize = new Dimension(300, 40);

        
        JLabel lblPodajMiasto = new JLabel("Podaj miasto:");
        lblPodajMiasto.setFont(LABEL_FONT);
        lblPodajMiasto.setPreferredSize(lblSize);
        springLayout.putConstraint(SpringLayout.NORTH, lblPodajMiasto, odstepPionowyDuzy, SpringLayout.NORTH, frame.getContentPane());
        springLayout.putConstraint(SpringLayout.WEST, lblPodajMiasto, marginesPoziomy, SpringLayout.WEST, frame.getContentPane());
        frame.getContentPane().add(lblPodajMiasto);
        
        txtMiasto = new JTextField();
        txtMiasto.setFont(TEXT_FONT);
        springLayout.putConstraint(SpringLayout.NORTH, txtMiasto, odstepPionowyMaly, SpringLayout.SOUTH, lblPodajMiasto);
        springLayout.putConstraint(SpringLayout.WEST, txtMiasto, wciecie, SpringLayout.WEST, lblPodajMiasto);
        frame.getContentPane().add(txtMiasto);
        txtMiasto.setColumns(10);
        
        JButton btnPobierzDlaMiasta = new JButton("Pobierz dla miasta");
        btnPobierzDlaMiasta.setFont(BUTTON_FONT);
        btnPobierzDlaMiasta.setPreferredSize(buttonSize);
        springLayout.putConstraint(SpringLayout.NORTH, btnPobierzDlaMiasta, odstepPionowyMaly, SpringLayout.SOUTH, txtMiasto);
        springLayout.putConstraint(SpringLayout.WEST, btnPobierzDlaMiasta, marginesPoziomy, SpringLayout.WEST, frame.getContentPane());
        frame.getContentPane().add(btnPobierzDlaMiasta);
        
        JLabel lblDugoGeo = new JLabel("Długość geo:");
        lblDugoGeo.setFont(LABEL_FONT);
        lblDugoGeo.setPreferredSize(lblSize);
        springLayout.putConstraint(SpringLayout.NORTH, lblDugoGeo, odstepPionowyDuzy, SpringLayout.SOUTH, btnPobierzDlaMiasta);
        springLayout.putConstraint(SpringLayout.WEST, lblDugoGeo, marginesPoziomy, SpringLayout.WEST, frame.getContentPane());
        frame.getContentPane().add(lblDugoGeo);
        
        spinner_Lon = new JSpinner();
        spinner_Lon.setModel(new SpinnerNumberModel(21.0, -180.0, 180.0, 0.5));
        spinner_Lon.setFont(TEXT_FONT);
        spinner_Lon.setPreferredSize(spinnerSize);
        springLayout.putConstraint(SpringLayout.NORTH, spinner_Lon, odstepPionowyMaly, SpringLayout.SOUTH, lblDugoGeo);
        springLayout.putConstraint(SpringLayout.WEST, spinner_Lon, wciecie, SpringLayout.WEST, lblDugoGeo);
        frame.getContentPane().add(spinner_Lon);
        
        JLabel lblSzerokoGeo = new JLabel("Szerokość geo:");
        lblSzerokoGeo.setFont(LABEL_FONT);
        lblSzerokoGeo.setPreferredSize(lblSize);
        springLayout.putConstraint(SpringLayout.NORTH, lblSzerokoGeo, 0, SpringLayout.NORTH, lblDugoGeo);
        springLayout.putConstraint(SpringLayout.WEST, lblSzerokoGeo, marginesPoziomy, SpringLayout.EAST, spinner_Lon);
        frame.getContentPane().add(lblSzerokoGeo);
        
        spinner_Lat = new JSpinner();
        spinner_Lat.setModel(new SpinnerNumberModel(52.0, -90.0, 90.0, 0.5));
        spinner_Lat.setFont(TEXT_FONT);
        spinner_Lat.setPreferredSize(spinnerSize);		
        springLayout.putConstraint(SpringLayout.NORTH, spinner_Lat, odstepPionowyMaly, SpringLayout.SOUTH, lblSzerokoGeo);
        springLayout.putConstraint(SpringLayout.WEST, spinner_Lat, wciecie, SpringLayout.WEST, lblSzerokoGeo);
        frame.getContentPane().add(spinner_Lat);

        JButton btnPobierzDlaWsprzdnych = new JButton("Pobierz dla współrzędnych");
        btnPobierzDlaWsprzdnych.setFont(BUTTON_FONT);
        btnPobierzDlaWsprzdnych.setPreferredSize(buttonSize);
        springLayout.putConstraint(SpringLayout.NORTH, btnPobierzDlaWsprzdnych, odstepPionowyDuzy, SpringLayout.SOUTH, spinner_Lon);
        springLayout.putConstraint(SpringLayout.WEST, btnPobierzDlaWsprzdnych, marginesPoziomy, SpringLayout.WEST, frame.getContentPane());
        frame.getContentPane().add(btnPobierzDlaWsprzdnych);
        
        JLabel lblTemperatura = new JLabel("Temperatura:");
        lblTemperatura.setFont(LABEL_FONT);
        lblTemperatura.setPreferredSize(lblSize);
        springLayout.putConstraint(SpringLayout.NORTH, lblTemperatura, odstepPionowyDuzy, SpringLayout.SOUTH, btnPobierzDlaWsprzdnych);
        springLayout.putConstraint(SpringLayout.WEST, lblTemperatura, marginesPoziomy, SpringLayout.WEST, frame.getContentPane());
        frame.getContentPane().add(lblTemperatura);
        
        lblT = new JLabel();
        lblT.setFont(RESULT_FONT);
        lblT.setPreferredSize(resultSize);
        springLayout.putConstraint(SpringLayout.SOUTH, lblT, 0, SpringLayout.SOUTH, lblTemperatura);
        springLayout.putConstraint(SpringLayout.WEST, lblT, wciecie, SpringLayout.EAST, lblTemperatura);
        frame.getContentPane().add(lblT);

        JLabel lblWiatr = new JLabel("Wiatr:");
        lblWiatr.setFont(LABEL_FONT);
        lblWiatr.setPreferredSize(lblSize);
        springLayout.putConstraint(SpringLayout.NORTH, lblWiatr, odstepPionowyMaly, SpringLayout.SOUTH, lblTemperatura);
        springLayout.putConstraint(SpringLayout.WEST, lblWiatr, marginesPoziomy, SpringLayout.WEST, frame.getContentPane());
        frame.getContentPane().add(lblWiatr);
        
        lblW = new JLabel();
        lblW.setFont(RESULT_FONT);
        lblW.setPreferredSize(resultSize);
        springLayout.putConstraint(SpringLayout.SOUTH, lblW, 0, SpringLayout.SOUTH, lblWiatr);
        springLayout.putConstraint(SpringLayout.WEST, lblW, wciecie, SpringLayout.EAST, lblWiatr);
        frame.getContentPane().add(lblW);
        
        btnPobierzDlaMiasta.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                pobierzDlaMiasta();
            }
        });

        btnPobierzDlaWsprzdnych.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                pobierzDlaWspolrzednych();
            }
        });
        
        frame.addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(WindowEvent evt) {
                pobieraczka.close();
                super.windowClosing(evt);
            }
        });
    }

    private void pobierzDlaMiasta() {
        String miasto = txtMiasto.getText();
        if(miasto.isEmpty()) {
            reset();
        } else {
            wykonajPobierzDlaMiasta(miasto);
        }
    }

    private void pobierzDlaWspolrzednych() {
        double longitude = ((Number)spinner_Lon.getValue()).doubleValue();
        double latitude = ((Number)spinner_Lat.getValue()).doubleValue();
        
        wykonajPobierzDlaWspolrzednych(longitude, latitude);
    }

    private void wykonajPobierzDlaWspolrzednych(double longitude, double latitude) {
        SwingWorker<Optional<Pogoda>, Void> worker2 = new SwingWorker<>() {
            protected Optional<Pogoda> doInBackground() throws Exception {
                return pobieraczka.pobierzAktualnaPogode(latitude, longitude);
            }
            protected void done() {
                try {
                    Optional<Pogoda> wynik = this.get();
                    if(wynik.isPresent()) {
                        Pogoda pogoda = wynik.get();
                        lblT.setText(pogoda.temperature() + " ˚C");
                        lblW.setText(pogoda.windspeed() + " km/h");

                    }
                } catch (InterruptedException e) {
                } catch (ExecutionException e) {
                    reset();
                }
            }
        };
        worker2.execute();
    }

    private void wykonajPobierzDlaMiasta(String miasto) {
        SwingWorker<List<Lokalizacja>, Void> worker1 = new SwingWorker<>() {
            protected List<Lokalizacja> doInBackground() {
                return pobieraczka.szukajLokalizacji(miasto);
            }
            
            protected void done() {
                try {
                    List<Lokalizacja> lista = this.get();
                    if(lista.size() > 0) {
                        Lokalizacja lokalizacja = lista.get(0);
                        spinner_Lon.setValue(lokalizacja.longitude());
                        spinner_Lat.setValue(lokalizacja.latitude());
                        wykonajPobierzDlaWspolrzednych(lokalizacja.longitude(), lokalizacja.latitude());
                    }
                } catch (InterruptedException e) {
                } catch (ExecutionException e) {
                    reset();
                }
            }
        };
        worker1.execute();
    }

    private void reset() {
        spinner_Lon.setValue(0);
        spinner_Lat.setValue(0);
        lblT.setText("");
        lblW.setText("");
    }
}
