package hello;

import java.time.LocalDateTime;

import jakarta.inject.Inject;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;

@WebService
public class Hello {
    
    public String sayHello(String imie) {
        return "Witaj " + imie;
    }

    @WebResult(name="timestamp")
    public String currentTime() {
        return LocalDateTime.now().toString();
    }
    
    @WebResult(name="wynik")
    public long oblicz(
            @WebParam(name="liczba1") long liczba1,
            @WebParam(name="liczba2") long liczba2,
            @WebParam(name="operacja") String operacja) {
        return switch(operacja) {
            case "+" -> liczba1 + liczba2;
            case "-" -> liczba1 - liczba2;
            case "*" -> liczba1 * liczba2;
            case "/" -> liczba1 / liczba2;
            case "%" -> liczba1 % liczba2;
            default -> 0;
        };
    }
    
    @Inject
    private Benek benek;
    
    public String benek() {
        return String.valueOf(benek);
    }
    
}
