<%@page contentType="text/html;charset=UTF-8" language="java" %>
<%@taglib prefix="c" uri="jakarta.tags.core"%>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Lista produktów 7</title>
    <link rel="stylesheet" type="text/css" href="styl.css">
</head>
<body>
<h1>Lista produktów - wersja 7</h1>

<div class="koszyk">
    <h4>Koszyk</h4>
    <ul>
        <%-- Zauważmy, że dla obiektu koszyk nie wykonujemy już useBean.
             Po prostu zakładamy, że jest obecny (w sesji). Gdyby go nie było, to pętla się nie wykona. --%>
        <c:forEach var="elm" items="${basket.elements}">
            <li>${elm.productName} (${elm.quantity}) za <b>${elm.value}</b> <a href="remove_from_basket?productId=${elm.productId}">(–)</a></li>
        </c:forEach>
    </ul>
    <p class="total">Do zapłaty: ${basket.totalValue}</p>
</div>

<form id="wyszukiwarka" method="get">
    <h2>Filtr cen</h2>
    <table class="formularz">
        <tr><td><label for="min_price">Cena minimalna:</label></td>
            <td><input id="min_price" name="min_price" type="number" value="${param.min_price}"></td></tr>
        <tr><td><label for="max_price">Cena maksymalna:</label></td>
            <td><input id="max_price" name="max_price" type="number" value="${param.max_price}"></td></tr>
        <tr><td><button>Filtruj</button></td></tr>
    </table>
</form>

<jsp:useBean id="bean" class="sklep.web.ProductBean"/>
<jsp:setProperty name="bean" property="minPrice" param="min_price"/>
<jsp:setProperty name="bean" property="maxPrice" param="max_price"/>

<c:forEach var="product" items="${bean.filteredProducts}">
    <div class="product">
        <h3>${product.productName}</h3>
        <div class="price">Cena: ${product.price}</div>
        <div class="price">VAT ${product.vat * 100}%</div>
        <c:if test="${not empty(product.description)}">
            <p class="description">${product.description}</p>
        </c:if>
        <div class="action"><a href="add_to_basket?productId=${product.productId}">dodaj do koszyka</a></div>
    </div>
</c:forEach>
</body>
</html>
