package serwlety;

import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

/* Klasa spełnia wymagania "JavaBean", gdy:
- posiada konstruktor domyślny (publiczny, bezargumentowy)
- dostęp do własności (property) odbywa się poprzez metody dostępowe "gettery i settery"
 */
public class PrzykladowyBean {
    private String text = "";
    private AtomicInteger value = new AtomicInteger();

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getValue() {
        return value.incrementAndGet();
    }

    // Można utworzyć metodę, która wygląda jak getter, ale nie odczytuje żadnej zmiennej,
    // tylko pobiera dane w inny sposób.
    public LocalDateTime getCurrentTime() {
        return LocalDateTime.now();
    }

    public long getRandom() {
        return ThreadLocalRandom.current().nextLong();
    }

    public String wypiszPowitanie() {
        return "Witaj szanowny kliencie";
    }

    public String innePowitanie(String imie) {
        return "Witaj " + imie;
    }

    public void reset() {
        value.set(0);
        text = "";
    }

    public List<String> getWords() {
        return List.of(text.split("\\s+"));
    }

    @Override
    public String toString() {
        return "PrzykladowyBean z tekstem " + text + ", aktualna wartość licznika " + value.get();
    }
}

