package serwlety;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@WebServlet("/ping")
public class Ping extends HttpServlet {
    private static final long serialVersionUID = 1L;
       
    public Ping() {
        System.out.println("Powstaje obiekt serwletu");
    }
    
    @Override
    public void init() {
        System.out.println("init");
    }
    
    @Override
    public void destroy() {
        System.out.println("destroy");
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        /* Gdy uruchamiamy / wgrywamy aplikację, serwer tworzy obiekt tej klasy (serwletu, np. Ping).
         * Gdy przychodzi zapytanie HTTP typu GET skierowane pod adres tego serwletu (np. /Ping),
         * serwer wywołuje metodę doGet i w obiekcie request przekazuje nam informację o zapytaniu (adres, parametry, w przypadku metody POST także treść),
         * natomiast obiekt response dostajemy po to, aby za jego pomocą wygenerować odpowiedź.
         */
        String dt = LocalTime.now().toString();
        String addr = request.getRemoteAddr();
        int port = request.getRemotePort();
        String userAgent = request.getHeader("User-Agent");

        System.out.println(dt + ": zapytanie z adresu " + addr + ":" + port + "\nz przeglądarki " + userAgent);

        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        response.addCookie(new Cookie("czas", dt));

        PrintWriter out = response.getWriter();
        out.println("Halo halo, GET");

        out.println("ContextPath: " + request.getContextPath());
        out.println("RequestURI: " + request.getRequestURI());
        out.println("QueryString: " + request.getQueryString());

        out.println();
        out.println("LocalName: " + request.getLocalName());
        out.println("LocalAddr: " + request.getLocalAddr());
        out.println("LocalPort: " + request.getLocalPort());
        out.println();
        out.println("RemoteHost: " + request.getRemoteHost());
        out.println("RemoteAddr: " + request.getRemoteAddr() + ":" + request.getRemotePort());
        // itd.

        out.println();
        out.println("parametr x: " + request.getParameter("x"));
        out.println("parametr y: " + request.getParameter("y"));

        String[] wartosciX = request.getParameterValues("x");
        out.println("x jako tablica: " + Arrays.toString(wartosciX));

        out.println("Wszystkie parametry:");
        for (Map.Entry<String, String[]> e : request.getParameterMap().entrySet()) {
            String[] v = e.getValue();
            out.println(" * " + e.getKey() + " : " + Arrays.toString(v));
        }
        out.println();

        out.println("nagłówek Accept: " + request.getHeader("Accept"));
        out.println("nagłówek User-Agent: " + userAgent);
        out.println("Wszystkie nagłówki:");
        Enumeration<String> headerNames = request.getHeaderNames();
        while(headerNames.hasMoreElements()) {
            String nm = headerNames.nextElement();
            out.println(nm + ": " + request.getHeader(nm));
        }
        out.println();

        out.println("Wszystkie ciastka:");
        String poprzedniCzas = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null)
            for (Cookie cooky : cookies) {
                out.println("cookie " + cooky.getName() + " " + cooky.getValue());
                if ("czas".equals(cooky.getName())) {
                    poprzedniCzas = cooky.getValue();
                }
            }
        out.println("czas teraz    : " + dt);
        out.println("czas poprzedni: " + poprzedniCzas);
    }
    
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String contentType = request.getHeader("Content-Type");
        int contentLenght = request.getContentLength();
        String enc = request.getCharacterEncoding();
        
        
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.println("Halo halo, POST");
        out.println("Przyszła treść typu: " + contentType + " , enc: " + enc);
        out.println("Rozmiar: " + contentLenght);
        out.println();
        
        // dane binarne: request.getInputStream()
        try(BufferedReader reader = request.getReader()) {
            out.println("Cały tekst:");
            String line;
            while((line = reader.readLine()) != null) {
                out.println(line);
            }
        }
    }

    @Override
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String contentType = request.getHeader("Content-Type");
        int contentLenght = request.getContentLength();
        String enc = request.getCharacterEncoding();
        
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.println("Halo halo, PUT");
        out.println("Przyszła treść typu: " + contentType + " , enc: " + enc);
        out.println("Rozmiar: " + contentLenght);
        out.println();
        
        try(BufferedReader reader = request.getReader()) {
            out.println("Cały tekst:");
            String line;
            while((line = reader.readLine()) != null) {
                out.println(line);
            }
        }
    }
    
    @Override
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.println("Halo halo, DELETE");
    }

}
