package serwlety;

import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@WebServlet("/hello.html")
public class HelloHtml extends HttpServlet {
    private static final DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.append("""
                <!DOCTYPE html>
                <html>
                <head>
                </head>
                <body>
                <h1>Hello HTML</h1>
                <p>Ala ma kota, to jest HTML</p>
                <p>Teraz jest godzina <strong>
                """);
        out.append(LocalTime.now().format(df));
        out.append("""
                </strong></p>
                </body>
                </html>
                """);
    }
    
    
}
