package gotowe.postgresql;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class P13c_Blob_Download {

    public static void main(String[] args) {
        String sql = "SELECT photo_id, file_name, bytes FROM photos ORDER BY 1";
        
        JFileChooser fileChooser = new JFileChooser(".");
        fileChooser.setFileFilter(new FileNameExtensionFilter("Pliki graficzne", "jpg", "jpeg", "png", "bmp"));

        try(Connection c = DriverManager.getConnection(Ustawienia.URL, Ustawienia.USER, Ustawienia.PASSWD)) {
            // org.postgresql.util.PSQLException: Large Objects may not be used in auto-commit mode
            c.setAutoCommit(false);
            c.setReadOnly(true);

            try(PreparedStatement stmt = c.prepareStatement(sql);
                ResultSet rs = stmt.executeQuery()) {
                while(rs.next()) {
                    int id = rs.getInt(1);
                    String fileName = rs.getString(2);
                    fileChooser.setDialogTitle("Zapisz plik nr " + id);
                    fileChooser.setSelectedFile(new File(fileName));
                    int wybor = fileChooser.showSaveDialog(null);
                    if(wybor != JFileChooser.APPROVE_OPTION) continue;
                    File selectedFile = fileChooser.getSelectedFile();
                    try(InputStream input = rs.getBinaryStream(3);
                        OutputStream output = new FileOutputStream(selectedFile)) {
                        input.transferTo(output);
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            JOptionPane.showMessageDialog(null, "Gotowe");
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

}
