-- DROP TABLE sprzedaz;

CREATE TABLE sprzedaz (
    lp SERIAL PRIMARY KEY,
    data DATE,
    miasto VARCHAR(100),
    sklep VARCHAR(100),
    kategoria VARCHAR(100),
    towar VARCHAR(100),
    cena NUMERIC(10,2),
    sztuk INTEGER
);

-- Importujemy dane z CSV za pomocą import data w pgadmin4
-- To jest graficzny interfejs do polecenia COPY
-- https://www.postgresql.org/docs/current/sql-copy.html

-- Kopiowanie z pliku przez psql zadziałało w takie wersji:
-- \copy sprzedaz(data,miasto,sklep,kategoria,towar,cena,sztuk) from 'sprzedaz.csv' csv delimiter ',' header
-- Lista kolumn nie byłaby konieczna, gdyby tabela nie miała kolumny lp (której nie ma w pliku)

SELECT * FROM sprzedaz;

SELECT count(*) FROM sprzedaz;
