package pierwsze_watki;

import java.time.Duration;

public class PrzykladKonto2b {

    public static void main(String[] args) {
        Konto konto = new Konto(1, 25_000, "Ala");

        Thread wplacacz = new Thread(() -> {
            for(;;) {
                try {
                    Thread.sleep(Duration.ofSeconds(3));
                } catch(InterruptedException e) {
                    break;
                }
                konto.wplata(10_000);
                System.out.println("po wpłata: " + konto.getSaldo());
            }
        });
        Thread wyplacacz = new Thread(() -> {
            for(;;) {
                try {
                    Thread.sleep(Duration.ofMillis(150));
                    konto.wyplataCzekaj(970);
                    System.out.println("po wypłata: " + konto.getSaldo());
                } catch(InterruptedException e) {
                    break;
                } catch(Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        });

        System.out.println(konto);
        System.out.println("uruchamiam wątki...");

        wplacacz.start();
        wyplacacz.start();

        // program należy kończyć "zabijając" w IDE lub Ctrl+C w konsoli
    }

}
