package pierwsze_watki;

import java.util.Objects;

public class Konto {
    private final int numer;
    private int saldo;
    private String wlasciciel;
    
    public Konto(int numer, int saldo, String wlasciciel) {
        this.numer = numer;
        this.saldo = saldo;
        this.wlasciciel = wlasciciel;
    }

    public String getWlasciciel() {
        return wlasciciel;
    }

    public void setWlasciciel(String wlasciciel) {
        this.wlasciciel = wlasciciel;
    }

    public int getNumer() {
        return numer;
    }

    public synchronized int getSaldo() {
        return saldo;
    }
    
    public synchronized void wplata(int kwota) {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Kwota wpłaty nie jest dodatnia");
        }
        this.saldo += kwota;
        this.notify();
    }
    
    public synchronized void wyplata(int kwota) {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Kwota wypłaty nie jest dodatnia");
        }
        if(kwota > this.saldo) {
            throw new IllegalArgumentException("Kwota wypłaty przekracza saldo");
        }
        this.saldo -= kwota;
    }

    public synchronized void wyplataCzekaj(int kwota) {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Kwota wypłaty nie jest dodatnia");
        }
        try {
            while(kwota > this.saldo) {
                this.wait();
            }
            this.saldo -= kwota;
            this.notify();
        } catch(InterruptedException e) {
        }
    }

    @Override
    public String toString() {
        return "Konto nr " + numer + ", saldo=" + saldo + ", wlasciciel=" + wlasciciel;
    }

    @Override
    public int hashCode() {
        return Objects.hash(numer, saldo, wlasciciel);
    }

    @Override
    public boolean equals(Object obj) {
        if(this == obj)
            return true;
        if(obj == null)
            return false;
        if(getClass() != obj.getClass())
            return false;
        Konto other = (Konto) obj;
        return numer == other.numer && saldo == other.saldo && Objects.equals(wlasciciel, other.wlasciciel);
    }
    
}
