package klasy;

import java.util.Objects;

public class Konto {
    private final int numer;
    private int saldo;
    private String wlasciciel;
    
    public Konto(int numer, int saldo, String wlasciciel) {
        this.numer = numer;
        this.saldo = saldo;
        this.wlasciciel = wlasciciel;
    }

    public String getWlasciciel() {
        return wlasciciel;
    }

    public void setWlasciciel(String wlasciciel) {
        this.wlasciciel = wlasciciel;
    }

    public int getNumer() {
        return numer;
    }

    public int getSaldo() {
        return saldo;
    }
    
    public void wplata(int kwota) {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Kwota wpłaty nie jest dodatnia");
        }
        this.saldo += kwota;
    }
    
    public void wyplata(int kwota) {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Kwota wypłaty nie jest dodatnia");
        }
        if(kwota > saldo) {
            throw new IllegalArgumentException("Kwota wypłaty przekracza saldo");
        }
        this.saldo -= kwota;
    }

    @Override
    public String toString() {
        return "Konto nr " + numer + ", saldo=" + saldo + ", wlasciciel=" + wlasciciel;
    }

    @Override
    public int hashCode() {
        return Objects.hash(numer, saldo, wlasciciel);
    }

    @Override
    public boolean equals(Object obj) {
        if(this == obj)
            return true;
        if(obj == null)
            return false;
        if(getClass() != obj.getClass())
            return false;
        Konto other = (Konto) obj;
        return numer == other.numer && saldo == other.saldo && Objects.equals(wlasciciel, other.wlasciciel);
    }
    
}
