package sprzedaz.wydajnosc;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import sprzedaz.MaszynaWczytujaca2;
import sprzedaz.Transakcja;

/* W tej wersji dane są czytane stumieniowo (Files.lines) i od razu przetwarzane.
 * Strumień zrównoleglony - działa szybciej
 */
public class CzytajILicz4 {

	static void calaRobota() {
		try {
			File plik = new File(WyczarujPliki.DUZY_PLIK);
			MaszynaWczytujaca2 maszynaWczytujaca = new MaszynaWczytujaca2();

			Map<String, BigDecimal> sumyDouble = Files.lines(plik.toPath())
			    .skip(1)
				.parallel()
				.map(maszynaWczytujaca::wczytajJedenRekord)
				.collect(Collectors.groupingBy(Transakcja::miasto,
					Collectors.mapping(Transakcja::wartosc,
						Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));

				sumyDouble.forEach((k, v) -> System.out.printf(Locale.US, "%12s - %12.2f\n", k, v));
				System.out.println();

		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public static void main(String[] args) {
		Pomiary.zmierzCzasDzalania(CzytajILicz4::calaRobota);
		Pomiary.wypiszPamiec();
		System.out.println("gc...");
		System.gc();
		try {
			Thread.sleep(2000);
		} catch (InterruptedException e) {
		}
		Pomiary.wypiszPamiec();
	}

}
