package sprzedaz.wydajnosc;

import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import sprzedaz.MaszynaWczytujaca2;
import sprzedaz.Transakcja;

/* W tej wersji dane są najpierw czytane do pamięci (ArrayList), a dopiero potem przetwarzane. */
public class CzytajILicz2 {

	static void calaRobota() {
		try {
			File plik = new File(WyczarujPliki.DUZY_PLIK);
			List<Transakcja> lista = MaszynaWczytujaca2.wczytajCalyPlik(plik);

			Map<String, BigDecimal> sumy = lista.stream()
				.collect(Collectors.groupingBy(Transakcja::miasto,
					Collectors.mapping(Transakcja::wartosc,
						Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));

				sumy.forEach((k, v) -> System.out.printf(Locale.US, "%12s - %12.2f\n", k, v));
				System.out.println();

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void main(String[] args) {
		Pomiary.zmierzCzasDzalania(CzytajILicz2::calaRobota);
		Pomiary.wypiszPamiec();
		System.out.println("gc...");
		System.gc();
		try {
			Thread.sleep(2000);
		} catch (InterruptedException e) {
		}
		Pomiary.wypiszPamiec();
	}

}
