package sprzedaz;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class MaszynaWczytujaca1 {

    public static List<Transakcja> wczytaj() {
        return wczytaj("sprzedaz.csv");
    }

    public static List<Transakcja> wczytaj(String sciezka) {
        return wczytaj(new File(sciezka));
    }

    public static List<Transakcja> wczytaj(File plik) {
        List<Transakcja> lista = new ArrayList<>();
        try(Scanner scanner= new Scanner(plik)) {
            scanner.nextLine();
            while(scanner.hasNextLine()) {
                String linia = scanner.nextLine();
                String[] t = linia.split(",", -1);

                Transakcja transakcja = new Transakcja(LocalDate.parse(t[0]),
                        t[1], t[2], t[3],t[4],
                        new BigDecimal(t[5]), Integer.parseInt(t[6]));
                lista.add(transakcja);
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return lista;
    }
}
