package sprzedaz;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Grupowanie6b {
    public static void main(String[] args) throws IOException {
        List<Transakcja> lista = MaszynaWczytujaca2.wczytajCalyPlik();
        Map<String, BigDecimal> sumy = lista.stream()
                .collect(Collectors.groupingBy(Transakcja::miasto,
                        Collectors.mapping(Transakcja::wartosc,
                                Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));

        sumy.forEach((miasto, suma) -> System.out.printf("%-10s : %12s%n", miasto, suma));
    }
}
