package sprzedaz;

import java.math.BigDecimal;
import java.util.*;

/* W tej wersji widzimy często stosowany schemat "grupowanie z wykorzystaniem słownika.
   Korzystamy z operacji dostępnych od Java 5.
 */
public class Grupowanie1 {
    public static void main(String[] args) {
        List<Transakcja> lista = MaszynaWczytujaca1.wczytaj();
        Map<String, BigDecimal> slownik = new TreeMap<>();

        for(Transakcja r : lista) {
            if(slownik.containsKey(r.miasto())) {
                // to jest kolejny rekord z danego miasta → do obliczonej sumy dodajemy kolejny składnik
                BigDecimal suma = slownik.get(r.miasto());
                slownik.put(r.miasto(), suma.add(r.wartosc()));
            } else {
                // to jest pierwszy rekord z danego miasta → dodajemy pierwszy wpis
                slownik.put(r.miasto(), r.wartosc());
            }
        }

        // System.out.println(slownik);
        // Przeglądanie zawartości słownika jako kluczy z wartościami
        // wersja "Java 5":
        for (Map.Entry<String, BigDecimal> entry : slownik.entrySet()) {
            System.out.printf("%-10s : %12s%n", entry.getKey(), entry.getValue());
        }
    }
}
