package pan_tadeusz;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PoliczSlowaStream {

    private static final String SEP = "[^\\p{L}\\d]+";

    public static void main(String[] args) {
        try(Stream<String> lines = Files.lines(Paths.get("pan_tadeusz.txt"), Charset.forName("UTF-8"))) {
            lines.flatMap(line -> Stream.of(line.split(SEP)))
                .collect(Collectors.groupingBy(Function.identity(), Collectors.counting()))
                .entrySet()
                .stream()
                .sorted(Map.Entry.<String, Long>comparingByValue().reversed())
                .forEachOrdered(entry -> System.out.println(entry.getKey() + ": " + entry.getValue()));
        } catch(IOException e) {
            e.printStackTrace();
        }
    }

}
