package pan_tadeusz;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.Collator;
import java.util.List;
import java.util.Locale;

public class P13_PosortujLinieZFiltrowaniem {

    public static void main(String[] args) {
        try {
            System.out.println("Czytanie...");
            List<String> lines = Files.readAllLines(Paths.get("pan_tadeusz.txt"), Charset.forName("UTF-8"));
            System.out.println("Wczytałem linii: " + lines.size());

            System.out.println("Filtrowanie...");
            lines.removeIf(String::isBlank);
            lines.replaceAll(String::strip);
            System.out.println("Po przefiltorowaniu linii jest: " + lines.size());

            System.out.println("Sortowanie...");
            // lines.sort(Collator.getInstance());
            lines.sort(Collator.getInstance(Locale.of("pl", "PL")));
            System.out.println("Zapisywanie...");
            Files.write(Paths.get("posortowany3.txt"), lines);
            System.out.println("Gotowe.");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
