package pan_tadeusz;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.Collator;
import java.util.List;
import java.util.Locale;

public class P12_PosortujLiniePL {

    public static void main(String[] args) {
        try {
            System.out.println("Czytanie...");
            List<String> lines = Files.readAllLines(Paths.get("pan_tadeusz.txt"), Charset.forName("UTF-8"));
            System.out.println("Wczytałem " + lines.size() + " linii");
            System.out.println("Sortowanie...");
            // lines.sort(null); // wg kodów Unicode
            // lines.sort(Collator.getInstance()); // wg bieżących ustawień językowych
            // lines.sort(Collator.getInstance(Locale.FRANCE)); // wg alfabetu konkretnego języka
            lines.sort(Collator.getInstance(Locale.of("pl", "PL")));
            // lines.sort(Collator.getInstance(Locale.of("en", "GB")));
            System.out.println("Zapisywanie...");
            Files.write(Paths.get("posortowany2.txt"), lines);
            System.out.println("Gotowe.");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
