package pan_tadeusz;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.Collator;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;

// Dla każdego słowa oblicz, ile razy ono występuje w pliku
// Wypisz w takiej postaci:
// tadeusz - 107
// telimena - 54
// ... - ...
public class P06_PoliczKazdeSlowo_v1 {

    public static void main(String[] args) {
        System.out.println("Startujemy");
        // Map<String, Integer> slowa = new HashMap<>();
        // Map<String, Integer> slowa = new TreeMap<>();
        // Map<String, Integer> slowa = new TreeMap<>(Collator.getInstance());
        Map<String, Integer> slowa = new TreeMap<>(Collator.getInstance(Locale.of("pl", "PL")));

        try(Scanner scanner = new Scanner(new File("pan_tadeusz.txt"))) {
            scanner.useDelimiter("[^\\p{L}\\d]+");
            while(scanner.hasNext()) {
                String slowo = scanner.next().toLowerCase();
                if(slowa.containsKey(slowo)) {
                    // to jest kolejne wystąpienie tego słowa - trzeba zwiększyć o 1
                    int ileBylo = slowa.get(slowo);
                    slowa.put(slowo, ileBylo+1);
                } else {
                    // to jest pierwsze wystąpienie tego słowa - trzeba wstawić 1
                    slowa.put(slowo, 1);
                }
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }

        // System.out.println(slowa);
        for(var entry : slowa.entrySet()) {
            System.out.printf("%-20s : %5d\n", entry.getKey(), entry.getValue());
        }

    }

}
