package p18_optional;

import java.time.LocalTime;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class OrElseGet {

    public static void main(String[] args) {
        Supplier<LocalTime> dajCzas = () -> {
            try { Thread.sleep(1000);
            } catch (InterruptedException e) { }
            return LocalTime.now();
        };

        System.out.println("A przed, " + LocalTime.now());
        LocalTime wynik1 = Stream.generate(dajCzas)
                .limit(5)
                .filter(t -> t.getSecond() >= 50)
                .findFirst()
                .orElse(LocalTime.now());
        System.out.println("A wynik: " + wynik1);
        System.out.println("A po:    " + LocalTime.now());
        System.out.println();

        System.out.println("B przed, " + LocalTime.now());
        LocalTime wynik2 = Stream.generate(dajCzas)
                .limit(5)
                .filter(t -> t.getSecond() >= 50)
                .findFirst()
                .orElseGet(LocalTime::now);
        System.out.println("B wynik: " + wynik2);
        System.out.println("B po:    " + LocalTime.now());


    }
}
