package p16_streamy.b_dzialanie;

import java.util.List;
import java.util.stream.Stream;

public class Zamykanie {
    public static void main(String[] args) {
        List<String> lista = List.of("Warszawa", "Kraków", "Wrocław", "Łódź", "Poznań");

        System.out.println("próba 0:");
        lista.stream()
                .onClose(() -> System.out.println("zamykanie 0"))
                .map(String::toUpperCase)
                .forEach(System.out::println);
                // samo wywołanie forEach nie skutkuje wywołaniem close

        System.out.println("____\npróba 1:");
        lista.stream()
                .onClose(() -> System.out.println("zamykanie 1"))
                .map(String::toUpperCase)
                // nie da się zapisać łańcuchowo tak ani odwrotnie:
                // .close().forEachOrdered(System.out::println)
                // .forEachOrdered(System.out::println).close()
                // zrobię tylko close
                .close();

        System.out.println("____\npróba 2:");
        Stream<String> stream2 = lista.stream().onClose(() -> System.out.println("zamykanie 2"));
        stream2.map(String::toUpperCase).forEach(System.out::println);
        stream2.close();

        System.out.println("____\npróba 3:");
        Stream<String> stream3 = lista.stream()
                .onClose(() -> System.out.println("zamykanie 3a"))
                .map(String::toUpperCase)
                .onClose(() -> System.out.println("zamykanie 3b"))
                ;
        stream3.forEach(System.out::println);
        stream3.close();

        System.out.println("____\npróba 4:");
        try(Stream<String> stream4 = lista.stream()
                .onClose(() -> System.out.println("zamykanie 4"))) {
            stream4.map(String::toUpperCase)
                    .forEach(System.out::println);
        }

        System.out.println("____\npróba 5:");
        try(Stream<String> stream5 = lista.stream()) {
            stream5.onClose(() -> System.out.println("zamykanie 5"))
                    .map(String::toUpperCase)
                    .forEach(System.out::println);
        }
    }
}
