package p15_kolekcje.z_zbierz_dane;

import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class P6_Slownik {
    // Słownik służy do przechowywania par klucz→wartość
    // Przy czym klucze muszą być unikalne. Dostęp po kluczu jest wygodny i wydajny.
    // Typ klucza powinien być łatwy do porównania.
    // Dobre typy dla klucza: Integer, Long, String, LocalDate

    // Podobnie, jak w przypadku zbiorów (Set), dla słowników (Map) mamy takie implementacje,
    // które różnią się kolejnością danych:
    // - HashMap - kolejność techniczna / chaotyczna
    // - LinkedHashMap - kolejność, w jakiej elementy były dodawane po raz pierwszy
    // - TreeMap - dane posortowane wg kluczy

    // W zaawansowanych zastosowaniach ważną implementacją słowników jest ConcurrentHashMap,
    // która poprawnie i wydajnie działa w aplikacjach wielowątkowych (rózne wątki mogą korzytać jednocześnie).

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        // Dla osoby o podanym imieniu pamiętamy, ile ma lat.
        Map<String, Integer> slownik = new HashMap<>();

        while(true) {
            System.out.print("Podaj kolejne imię: ");
            String imie = scanner.nextLine();
            if(imie.isEmpty()) break;
            System.out.print("Podaj wiek osoby " + imie + ": ");
            int wiek = scanner.nextInt();
            scanner.nextLine();
            slownik.put(imie, wiek);
        }

        System.out.println("Liczba elementów: " + slownik.size());
        System.out.println("Wszystkie imiona:");
        System.out.println(slownik);

        System.out.println();
        // Iteracja po elementach słownika.
        // Same klucze:
        for(String imie : slownik.keySet()) {
            System.out.print("; " + imie);
        }
        System.out.println();

        // Same wartości:
        for(Integer wiek : slownik.values()) {
            System.out.print(". " + wiek);
        }
        System.out.println();
        System.out.println();

        // Klucze wraz z wartościami:
        for(Map.Entry<String, Integer> osoba : slownik.entrySet()) {
            System.out.println("Osoba " + osoba.getKey() + " ma " + osoba.getValue() + " lat.");
        }
        System.out.println();

        // Od Java 8 można też pisać tak:
        slownik.forEach((imie, wiek) -> {
            System.out.println(" * " + imie + " → " + wiek);
        });
        System.out.println();

        while(true) {
            System.out.print("Podaj imię: ");
            // pusty string kończy
            String imie = scanner.nextLine();
            if(imie.isEmpty()) {
                break;
            }
            if(slownik.containsKey(imie)) {
                int wiek = slownik.get(imie);
                System.out.println("Osoba " + imie + " ma " + wiek + " lat.");
            } else {
                System.out.println("Nie znam osoby " + imie);
            }

            // Podstawową operacją do odczytywania danych ze słownika jest get(klucz).
            // Jeśli spróbujemy odczytać element spod nieistniejącego klucza, to wynikiem będzie null.
            // Pamiętajmy, by przy takim podejściu zapisywać wynik do zmiennej obiektowej.
            // Czyli nie tak: int wiek = slownik.get(imie);
            // A raczej tak: Integer wiek = slownik.get(imie);
            //    if(wiek != null) { ... }
        }
    }

}
