package p15_kolekcje.z_zbierz_dane;

import java.util.Arrays;
import java.util.Scanner;

// Program pobiera od użytkownika wiele imion i zapisuje w pamięci, aby później wypisać...
// W tej wersji imiona zapamiętujemy w tablicy.
// Tworząc tablicę musimy podać jej rozmiar.
// Tablice nie są tak elastyczne, jak listy i inne kolekcje,

public class P1_Tablica {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        System.out.print("Ile imion podasz? ");
        int size = scanner.nextInt();
        scanner.nextLine(); // ignorujemy resztę tej linii, a "kursor przechodzi do następnej"
        String[] tablica = new String[size];

        for(int i = 0; i < size; i++) {
            System.out.print("Podaj imię nr " + i + ": ");
            tablica[i] = scanner.nextLine();
        }

        System.out.println("Wszystkie imiona:");
        System.out.println(Arrays.toString(tablica));

        // Tablica i wszystkie typy kolekcji pozwalają na używanie pętli "for-each".
        for(String imie : tablica) {
            System.out.print("; witaj " + imie);
        }
        System.out.println();

        // Najbardziej oczywistym (i wydajnym) sposobem dostepu do elementów tablicy
        // jest dostęp po numerze pozycji za pomocą []
        // Użytkownik podaje numer, a program odczytuje wartość z podanej pozycji.
        // -1 kończy
        while(true) {
            System.out.print("Podaj nr pozycji: ");
            int pozycja = scanner.nextInt();
            scanner.nextLine();
            if(pozycja == -1) {
                break;
            }
            try {
                String imie = tablica[pozycja];
                System.out.println("Osoba nr " + pozycja + " to " + imie);
            } catch (Exception e) {
                System.out.println(e);
            }
        }
    }

}
