package p04_watki.pule;

import java.util.concurrent.*;

public class PuleWatkow_Lambda {

	public static void main(String[] args) throws InterruptedException, ExecutionException {
		try(ExecutorService pool = Executors.newFixedThreadPool(4)) {
			Future<?> futureVoid = pool.submit(() -> {
				System.out.println("Zadanie Runnable");
			});
			Future<String> futureString = pool.submit(() -> {
				System.out.println("Zadanie Callable");
				return "to jest wynik";
			});
			while(! futureString.isDone()) {
				System.out.println("czekam na koniec String");
			}
			String s = futureString.get();
			System.out.println("gotowe: " + s);
			pool.shutdown();
			// bez shutdown poniższy kod czekalby minutę, bo "może będą jeszcze jakieś zlecenia"
			if(pool.awaitTermination(1, TimeUnit.MINUTES)) {
				System.out.println("wszystko zrobione");
			}
		}
	}
}
