package p04_watki.dodatkowe;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.*;

public class PuleWatkow2 {
    // W pętli zlecamy wiele zadań typu Callable i zwracane obiekty Future dodajemy do listy.

    public static void main(String[] args) {
        System.out.println("Początek main");

        try(ExecutorService executorService = Executors.newFixedThreadPool(4)) {
            // synchronizowana nie jest tu konieczna, bo tylko w jednym wątku używamy tej listy
            // List<Future<String>> futures = Collections.synchronizedList(new ArrayList<>());
            List<Future<String>> futures = new ArrayList<>();

            for(int i = 0; i < 20; i++) {
                var numer = i;
                Future<String> future = executorService.submit(() -> {
                    System.out.println("Wątek " + Thread.currentThread().getName() + " wykonuje task nr " + numer);
                    int czas = ThreadLocalRandom.current().nextInt(300, 1300);
                    try {
                        Thread.sleep(Duration.ofMillis(czas));
                    } catch (InterruptedException e) {
                    }
                    return "Wynik zadania nr " + numer;
                });
                futures.add(future);
            }
            System.out.println("Wszystkie zadanie zlecone");

            // Dopóki lista zawiera jakiekolwiek zadania, przeglądamy ją w poszukiwaniu zadań z isDome == true
            // i wyniki tych zadań odbieramy w pierwszej kolejności

            // to by tylko usunęło bez odczytywania:
            // futures.removeIf(Future::isDone);

            while(!futures.isEmpty()) {
                boolean cokolwiek = false;
                for(Iterator<Future<String>> it = futures.iterator(); it.hasNext(); ) {
                    Future<String> future = it.next();
                    if(future.isDone()) {
                        cokolwiek = true;
                        it.remove();
                        try {
                            String wynik = future.get();
                            System.out.println("Wynik: " + wynik);
                        } catch (InterruptedException |ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                if(!cokolwiek) {
                    System.out.println("Nie ma żadnego zakończonego zadania");
                    try {
                        Thread.sleep(Duration.ofMillis(200));
                    } catch (InterruptedException e) {
                    }
                }
            }

        }
        System.out.println("Pula zamknięta");

        System.out.println("Koniec main");
    }
}
