package emps.v3_funkcyjnie;

import java.util.List;
import java.util.OptionalDouble;

import javax.swing.JOptionPane;

public class F4_SredniaJedenJob {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		String szukanyJob = JOptionPane.showInputDialog("Podaj szukany job", "Programmer");
		
		double srednia1 = emps.stream()
			.filter(emp -> emp.getJobTitle().equalsIgnoreCase(szukanyJob))
			.mapToInt(Employee::getSalary)
			.average()
			.orElse(0);
		JOptionPane.showMessageDialog(null, "Wersja prosta: " + srednia1);
		
		// Jeśli chcemy sprawdzić, czy zostało coś znalezione, możemy zapisać wynik jako OptionalDouble i sprawdzić ifem
		OptionalDouble srednia2 = emps.stream()
			.filter(emp -> emp.getJobTitle().equalsIgnoreCase(szukanyJob))
			.mapToInt(Employee::getSalary)
			.average();
		
		if(srednia2.isPresent()) {
			JOptionPane.showMessageDialog(null, String.format(
					"Średnia pensja na stanowisku %s wynosi %.2f",
					szukanyJob, srednia2.getAsDouble()));
		} else {
			JOptionPane.showMessageDialog(null, String.format("Nikt nie pracuje na stanowisku %s.", szukanyJob),
					"Brak danych", JOptionPane.WARNING_MESSAGE);
		}
	}

}
