package emps.v3_funkcyjnie;

import java.util.Comparator;
import java.util.List;

public class F2_Filtrowanie {
    // Program wypisuje tylko zarabiających >= 10 tys,
    // realizujemy to filtrowaniem, ale przy okazji pokazuję Wam schemat "filter / map" - podstawowe operacje na strumieniach.

    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytaj();

        emps.stream()
            .filter(emp -> emp.getSalary() >= 10_000)
            .forEach(emp -> System.out.println(emp.getFirstName() + " " + emp.getLastName()));

        System.out.println("\n-----------------------\n");

        emps.stream()
            .filter(emp -> emp.getSalary() <= 5000)
            .sorted(Comparator.comparing(Employee::getSalary))
            .map(emp -> emp.getFirstName() + " " + emp.getLastName() + " z pensją " + emp.getSalary())
            .map(String::toUpperCase) // ew.  .map(s -> s.toUpperCase())
            .forEach(System.out::println);

        // Cały ten ↑ zapis jest określany "pipeline", który składa się z:
        // - źródła danych
        // - dowolnej liczby operacji pośrednich (intermediate, tutaj są to filter i map)
        // - operacji końcowej (terminal, tutaj jest to forEach)
        // Każdy obiekt przechodzi przez kolejne etapy przetwarzania, "schodzi z góry w dół".

    }

}
