package emps.v3_funkcyjnie;

import java.io.FileNotFoundException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class CzegoSieNieDaWLambdach {
	static int sumaStatyczna = 0;

	public static void main(String[] args) throws FileNotFoundException {
		List<Employee> emps = ObslugaCSV.wczytaj();

		// czy damy radę obliczyć sumę pensji za pomocą tego nowego forEach?
		int sumaLokalna = 0;
		int[] tablica = {0};
		AtomicInteger ai = new AtomicInteger();

		emps.forEach(emp -> {
			// wewnątrz wyrażeń lambda nie wolno modyfikować zmiennych lokalnych
			// zdefiniowanych przed tym wyrażeniem
			// ograniczenie "effectively final"
			// sumaLokalna += emp.getSalary();

			// bardzo brzydkie, ale działa:
			sumaStatyczna += emp.getSalary();
			tablica[0] += emp.getSalary();
			// ai.incrementAndGet(); // ++
			ai.addAndGet(emp.getSalary()); // +=
		});

		System.out.println(sumaLokalna);
		System.out.println(sumaStatyczna);
		System.out.println(tablica[0]);
		System.out.println(ai);
		System.out.println();

		// właściwe podejście w stylu funkcyjnym:
		int suma = emps.stream().mapToInt(Employee::getSalary).sum();
		System.out.println(suma);
	}
}
