package emps.v2_obiektowo;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Grupowanie2 {
	// W tej wersji używam operacji getOrDefault (od Java 8), dzięki czemu nie trzeba pisać if

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj();

		Map<String, Integer> sumy = new TreeMap<>();
		Map<String, Integer> ilosci = new TreeMap<>();

		for(Employee emp : emps) {
			int suma = sumy.getOrDefault(emp.getJobTitle(), 0);
			sumy.put(emp.getJobTitle(), suma + emp.getSalary());
			int ile = ilosci.getOrDefault(emp.getJobTitle(), 0);
			ilosci.put(emp.getJobTitle(), ile+1);
		}

		for(String job : sumy.keySet()) {
			int suma = sumy.get(job);
			int ile = ilosci.get(job);
			double srednia = (double)suma / ile;
			System.out.printf("| %-32s | %2d | %8.2f |%n", job, ile, srednia);
		}
	}

}
