package emps.v2_obiektowo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Grupowanie1a {

    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytaj();
        Map<String, Integer> sumy = new HashMap<>();
        Map<String, Integer> ilosci = new HashMap<>();

        for(Employee emp : emps) {
            String jobTitle = emp.getJobTitle();
            if(sumy.containsKey(jobTitle)) {
                // gdy to jest kolejny pracownik ze stanowiska, które już występowało
                sumy.put(jobTitle, sumy.get(jobTitle) + emp.getSalary());
                ilosci.put(jobTitle, ilosci.get(jobTitle) + 1);
            } else {
                // gdy to jest pierwszy pracownik z danego stanowiska
                sumy.put(jobTitle, emp.getSalary());
                ilosci.put(jobTitle, 1);
            }
        }

        for(String job : sumy.keySet()) {
            int suma = sumy.get(job);
            int ile = ilosci.get(job);
            double srednia = (double)suma / ile;
            System.out.printf("%32s | %2d | %8.2f\n", job, ile, srednia);
        }
    }

}
