package emps.v2_obiektowo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Grupowanie1 {
    // W tej wersji widzimy klasyczny algorytm "agregacji danych za pomocą słownika"
    // Listę pracowników przeglądamy tylko raz, na bieżąco aktualizując słowniki.
    // W tej wersji używamy tylko podstawowych operacji na kolekcjach (sprzed Java 8)

    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytaj();

        Map<String, Integer> sumy = new HashMap<>();
        Map<String, Integer> ilosci = new HashMap<>();

        for(Employee emp : emps) {
            if(sumy.containsKey(emp.getJobTitle())) {
                // gdy to jest kolejny pracownik ze stanowiska, które już występowało
                int suma = sumy.get(emp.getJobTitle());
                suma += emp.getSalary();
                sumy.put(emp.getJobTitle(), suma);
                int ile = ilosci.get(emp.getJobTitle());
                ile += 1;
                ilosci.put(emp.getJobTitle(), ile);
            } else {
                // gdy to jest pierwszy pracownik z danego stanowiska
                sumy.put(emp.getJobTitle(), emp.getSalary());
                ilosci.put(emp.getJobTitle(), 1);
            }
        }

        for(String job : sumy.keySet()) {
            int suma = sumy.get(job);
            int ile = ilosci.get(job);
            double srednia = (double)suma / ile;
            System.out.printf("%32s | %2d | %8.2f\n", job, ile, srednia);
        }

    }

}
