package sprzedaz.wydajnosc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;

public class WyczarujPliki {

    public static final String DUZY_PLIK = "sprzedaz_200.csv";

	public static void main(String[] args) {
		try {
			List<String> linie = Files.readAllLines(Paths.get("sprzedaz.csv"));
			String naglowek = linie.getFirst();
			linie.remove(0);
			for(int n : new int[]{50, 200}) {
				String plik = "sprzedaz_"+n+".csv";
				System.out.println(plik);
				zapiszPowielone(naglowek, linie, n, new File(plik));
			}
			System.out.println("Gotowe");
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private static void zapiszPowielone(String naglowek, List<String> linie, int n, File file) throws FileNotFoundException {
		try(PrintWriter out = new PrintWriter(file)) {
		    out.println(naglowek);
			for(int tura = 0; tura < n; tura ++) {
				for (String linia : linie) {
					out.println(linia);
				}
			}
		}
	}

}
