package sprzedaz.wydajnosc;

import java.util.Objects;

public class Opakowanie<T> {
	private T value;

	private Opakowanie(T v) {
		this.value = v;
	}
	
	public static <T> Opakowanie<T> empty() {
		return new Opakowanie<T>(null);
	}

	public static <T> Opakowanie<T> of(T value) {
		return new Opakowanie<T>(value);
	}
	
	public T get() {
		return value;
	}

	public void set(T value) {
		this.value = value;
	}
	
	@Override
	public String toString() {
		return "{" + String.valueOf(value) + "}";
	}

	@Override
	public int hashCode() {
		return Objects.hash(value);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Opakowanie other = (Opakowanie) obj;
		return Objects.equals(value, other.value);
	}

	
}
