package sprzedaz;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Grupowanie5 {
    public static void main(String[] args) {
        List<Transakcja> lista = MaszynaWczytujaca1.wczytaj();

        Map<String, List<Transakcja>> grupy = lista.stream()
                .collect(Collectors.groupingBy(Transakcja::miasto));
        // Tak wywołany kolektor groupingBy zwraca słownik, w którym dla każdej wartości klucz (czyli miasta)
        // zapisana jest lista wszystkich obiektów należących do tej grupy (czyli rekordów z tego miasta).

        // Tutaj też zoabczymy przeglądanie słownika z sposób oparty o wyrażenia lambda, od Java 8
        grupy.forEach((miasto, rekordy) -> {
            System.out.println("Miasto " + miasto + ", liczba transakcji: " + rekordy.size());
            rekordy.forEach(r -> System.out.println(" * " + r.towar() + " za " + r.wartosc()));
            System.out.println();
        });
    }
}
