package p15_kolekcje.z_zbierz_dane;

import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;

// Zbiór (Set):
// - nie zawiera powtórzeń
// - nie wymaga deklarowania z góry liczby elementów;
// - operacja add w wyniku zwraca true, gdy element został dodany,
//   false, gdy element nie został dodany, bo już był
//   kończy się wyjątkiem w razie innych problemów
// - Set jest interfejsem; istnieje wiele implementacji zbioru,
//   z czego najczęściej używaną jest HashSet
// - HashSet działa w oparciu o metody hashCode i equals
//   - zazwyczaj jest najszybszą implementacją (szczególnie dla elementów typu String tak jest)
//   - zmienia kolejność elementów
// - LinkedHashSet działa odrobinkę wolniej podczas dodawania, a równie szybko przy odczycie,
//    ale za to zachowuje kolejność elementów
public class P4_HashSet {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        Set<String> zbior = new HashSet<>();

        while(true) {
            System.out.print("Podaj kolejne imię: ");
            String imie = scanner.nextLine();
            if(imie.isEmpty()) break;
            zbior.add(imie);
        }

        System.out.println("Liczba elementów: " + zbior.size());
        System.out.println("Wszystkie imiona:");
        System.out.println(zbior);

        // Tablica i wszystkie typy kolekcji pozwalają na używanie pętli "for-each".
        for(String imie : zbior) {
            System.out.print("; witaj " + imie);
        }
        System.out.println();

        // Drugi etap: użytkownik podaje imię, a program sprawdza, czy takie imię istnieje
        // to jest najbardziej podstawowa operacja dla zbiorów.
        // Niezależnie od implementacji ta operacja działa szybko (chociaż dla dużych zbiorów wersje Hash są trochę szybsze niż Tree)
        while(true) {
            System.out.print("Podaj imię: ");
            // pusty string kończy
            String imie = scanner.nextLine();
            if(imie.isEmpty()) {
                break;
            }
            if(zbior.contains(imie)) {
                System.out.println("TAK");
            } else {
                System.out.println("NIE");
            }
        }

    }

}
